<?php declare(strict_types = 1);

namespace GoPay\CronModule\Presenters;

use GoPay\Model\Payments;

class DefaultPresenter extends BasePresenter
{
	public Payments $payments;

	public function __construct(
		Payments $payments
	)
	{
		parent::__construct();
		$this->payments = $payments;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionCheckPaidStatus(): void
	{
		$this->payments->checkPaidStatus();
		$this->sendJson(['status' => 'ok']);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

}
