<?php declare(strict_types=1);

namespace GoPay\DI;

use Core\DI\CompilerExtension;
use GoPay\FrontModule\Model\Gopay;
use Nette;

class GopayExtension extends CompilerExtension
{
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['GoPay' => 'GoPay\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();
		
		$gopayKey = 'gopay.client';
		/** @var Nette\DI\Definitions\ServiceDefinition $gopay */
		$gopay = $builder->getDefinition($gopayKey);
		$originalArguments = $gopay->factory->arguments;
		$builder->removeDefinition($gopayKey);
		$builder->addDefinition($gopayKey)
				->setFactory(Gopay::class, [
					$builder->literal('$this->parameters["gopay"]'),
					'@core.sites',
					...$originalArguments,
				])
				->setAutowired();
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class): void
	{
		parent::afterCompile($class);
		$init    = $class->methods['initialize'];

		$init->addBody('GoPay\Model\GoPayConfig::setParams($this->parameters[\'goPay\']);');
	}
}
