<?php declare(strict_types = 1);

namespace GoPay\FrontModule\Model;

use Contributte\GopayInline\Client;
use Contributte\GopayInline\Config;
use Core\Model\Sites;

class Gopay extends Client
{
	protected Sites  $sites;
	protected ?array $config;

	/**
	 * @param Config|mixed ...$args
	 */
	public function __construct(?array $config, Sites $sites, ...$args)
	{
		$this->config = $config;
		$this->sites  = $sites;

		parent::__construct(...$args);
	}

	public function getGoId(): string
	{
		$config = $this->getConfig();

		return $config ? (string) $config['goId'] : parent::getGoId();
	}

	public function getClientId(): string
	{
		$config = $this->getConfig();

		return $config ? (string) $config['clientId'] : parent::getClientId();
	}

	public function getClientSecret(): string
	{
		$config = $this->getConfig();

		return $config ? (string) $config['clientSecret'] : parent::getClientSecret();
	}

	protected function getConfig(): ?array
	{
		$currentSite = $this->sites->getCurrentSite();
		$siteConfig  = $this->config[$currentSite->getIdent()] ?? null;
		$config      = null;

		if ($siteConfig) {
			$config = $siteConfig[$currentSite->getCurrentDomain()->getLang()] ?? $siteConfig;
		}

		return $config;
	}

}
