<?php declare(strict_types = 1);

namespace GPWebPay\DI;

use Core\DI\CompilerExtension;
use GPWebPay\FrontModule\Model\ResponseFactory;
use Nette\PhpGenerator\ClassType;

class GPWebPayExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['GPWebPay' => 'GPWebPay\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		$builder->removeDefinition('gpwebpay.responseFactory');
		$builder->addDefinition('gpwebpay.responseFactory')
			->setType(ResponseFactory::class);
	}

	public function afterCompile(ClassType $class)
	{
		parent::afterCompile($class);

		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('GPWebPay\Model\GPWebPayConfig::setParams(?);', [$builder->parameters['gpwebpay'] ?? []]);
	}
}
