<?php declare(strict_types = 1);

namespace Import\AdminModule\Components;

use Core\Model\Helpers\Arrays;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Import\AdminModule\Model\ImportGroups;
use Import\AdminModule\Model\Imports;
use Import\AdminModule\Model\ImportTypes;
use Import\AdminModule\Model\ProcessingTypes;
use Import\AdminModule\Model\Readers\XmlReader;
use Import\Model\Entities\Import;
use Import\Model\Entities\ImportGroup;
use Nette\Utils\ArrayHash;

/**
 * Class ImportGroupForm
 * @package Import\AdminModule\Components
 */
class ImportGroupForm extends BaseControl
{
	/** @var ImportGroup */
	protected $importGroup;

	/** @var ImportGroups */
	protected $importGroupsService;

	/** @var Imports */
	protected $importsService;

	public function __construct(ImportGroups $importGroups, Imports $imports)
	{
		$this->importGroupsService = $importGroups;
		$this->importsService      = $imports;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	public function createComponentForm()
	{
		$form = $this->createForm();

		$imports = $this->importsService->getEr()->findPairs([], 'title', ['position' => 'ASC'], 'id');

		$form->addText('title', 'import.import.title');
		$form->addBool('isActive', 'import.import.isActive');
		$form->addCheckboxList('imports', 'import.importGroupForm.imports', $imports);

		$form->addSaveCancelControl();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$importGroup = $this->importGroup ?: new ImportGroup($values->title);

			$importGroup->title    = $values->title;
			$importGroup->isActive = $values->isActive;

			foreach ($importGroup->getImports()->toArray() as $import) {
				$import->setGroup(null);
				$this->em->persist($import);
			}

			foreach ($values->imports as $import) {
				$import = $this->em->getReference(Import::class, $import);
				$import->setGroup($importGroup);
				$this->em->persist($import);
			}

			$flashMessage = $importGroup->getId() ? 'import.importGroupForm.edited' : 'import.importGroupForm.added';

			$this->em->persist($importGroup)->flush();
			$form->addCustomData('importGroupId', $importGroup->getId());
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	/*******************************************************************************************************************
	 * ==================  GET / SET
	 */

	public function setImportGroup($id)
	{
		$this->importGroup = $this->importGroupsService->get($id);

		if ($this->importGroup) {
			$form        = $this['form'];
			$importGroup = $this->importGroup;

			$form->setDefaults([
				'title'    => $importGroup->title,
				'isActive' => $importGroup->isActive,
			]);

			$d = [];

			foreach ($importGroup->getImports() as $import) {
				if (array_key_exists($import->getId(), $form['imports']->getItems()))
					$d[] = $import->getId();
			}

			$form['imports']->setDefaultValue($d);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
