<?php declare(strict_types = 1);

namespace Import\AdminModule\Model\Readers;

use Core\Model\Helpers\Arrays;
use Nette\Utils\ArrayHash;
use Nette\Utils\Strings;

/**
 * Class XmlReader
 * @package Import\AdminModule\Model\Readers
 */
class XmlReader implements IReader
{
	/** @var string */
	protected $xPath;

	/** @var string */
	protected $fileContent;

	/** @var \SimpleXMLElement[] */
	protected $cachedRawData;

	public function __construct($fileContent)
	{
		$this->fileContent = $fileContent;
	}

	/**
	 * @param $xPath
	 *
	 * @return $this
	 */
	public function setXpath($xPath)
	{
		$this->xPath = $xPath;

		return $this;
	}

	/**
	 * @return array
	 */
	public function getKeys()
	{
		$keys = [];

		foreach ($this->getRawData() as $row) {
			foreach (array_keys($row) as $k)
				$keys[$k] = $k;
		}

		return $keys;
	}

	/**
	 * @return array
	 */
	public function getValues()
	{
		$result = [];

		foreach ($this->getRawData() as $row) {
			foreach ($row as $rk => $rv) {
				if (count($result[$rk]) >= 15)
					break 2;

				if (is_string($rv) || is_numeric($rv))
					$result[$rk][] = $rv;
			}
		}

		return $result;
	}

	/**
	 * @return null|array
	 */
	protected function getRawData()
	{
		if (!$this->cachedRawData) {
			$data = simplexml_load_string($this->fileContent, "SimpleXMLElement", LIBXML_NOCDATA | LIBXML_PARSEHUGE);
			$data = json_encode($data);
			$data = json_decode($data, true);

			if (!is_bool($data) && count($data) == 1)
				$data = array_values($data)[0];
			if (isset($data['SHOPITEM']))
				$data = $data['SHOPITEM'];
			if (isset($data['ShopItem']))
				$data = $data['ShopItem'];

			foreach ($data as &$row) {
				if (isset($row['@attributes'])) {
					$row += $row['@attributes'];
					unset($row['@attributes']);
				}
			}

			$this->cachedRawData = $data;
			$data                = null;
			$this->fileContent   = null;
		}

		return $this->cachedRawData;
	}

	/**
	 * TODO vylepšit
	 *
	 * @return array
	 */
	public function getData()
	{
		$rawData = $this->getRawData();
		$data    = [];

		foreach ($rawData as $row) {
			$r = [];

			foreach ($row as $k => $v) {
				if (is_array($v) && empty($v))
					continue;

				if (Arrays::strposa(strtolower($k),
						['product', 'desc', 'url', 'img', 'manufa', 'categorytext', 'item', 'text'])
					&& !is_array($v)) {
					$v = trim((string) $v);
				} else if (Arrays::strposa(strtolower($k), ['price', 'vat'])) {
					$v = str_replace(',', '.', (string) $v);
					$v = number_format((float) $v, 2, '.', '');
				} else if (is_array($v)) {
					$v = $this->loopArray($v);
				}

				$r[$k] = $v;
			}
			$data[] = $r;
		}
		$rawData = null;

		return $data;
	}

	/**
	 * @param $arr
	 *
	 * @return array|string
	 */
	private function loopArray($arr)
	{
		$oArr = $arr;
		$arr  = (array) $arr;
		if (empty($arr))
			return (string) $oArr;

		$paramKeyNames   = ['PARAM_NAME', 'PARAM', 'NAME'];
		$paramValueNames = ['VAL', 'VALUE'];
		$params          = [];

		foreach ($paramKeyNames as $keyName) {
			if (isset($arr[$keyName])) {
				$valueName = null;
				foreach ($paramValueNames as $vName) {
					if (isset($arr[$vName]))
						$valueName = $vName;
				}

				if ($valueName) {
					if (is_array($arr[$keyName]))
						foreach ($arr[$keyName] as $i => $key)
							$params[trim($key)] = trim((string) $arr[$valueName][$i]);
					else if (is_string($arr[$keyName]) || is_numeric($arr[$keyName]))
						$params[(string) $arr[$keyName]] = (string) $arr[$valueName];
				}
			}
		}

		$tmp = [];
		if (empty($params)) {
			foreach ($arr as $key => $value) {
				if (is_array($value)) {
					$tmp[$key] = $this->loopArray($value);
				} elseif (is_string($value) || is_numeric($value))
					$tmp[$key] = $value;
			}
		}

		foreach ($tmp as $key => $value) {
			if (is_array($value) && count($value) == 1) {
				$params[key($value)] = $value[key($value)];
			} else
				$params[$key] = $value;
		}

		$arr = null;

		return $params;
	}
}
