<?php declare(strict_types = 1);

namespace Import\CronModule\Presenters;

use Import\AdminModule\Model\ImportGroups;
use Import\AdminModule\Model\Imports;
use Import\AdminModule\Model\ProcessingTypes;
use Import\Model\Entities\Import;
use Import\Model\Entities\ImportHistory;
use Kdyby\Doctrine\EntityManager;
use Nette\Utils\DateTime;
use Tracy\Debugger;

/**
 * Class DefaultPresenter
 * @package Import\CronModule\Presenters
 */
class DefaultPresenter extends BasePresenter
{
	/** @var Imports @inject */
	public $importsService;

	/** @var ImportGroups @inject */
	public $importGroupsService;

	/** @var ProcessingTypes @inject */
	public $processingTypes;

	/** @var EntityManager @inject */
	public $em;

	public function actionRun($id)
	{
		$import       = $this->importsService->get($id);
		$responseData = $this->runImport($import);

		$this->sendJson($responseData);
	}

	public function actionRunGroup($id)
	{
		$importGroup    = $this->importGroupsService->get($id);
		$resultResponse = ['status' => 'error', 'message' => '', 'imports' => []];

		if (!$importGroup) {
			$resultResponse['message'] = "Import id '$id' not found";
			$this->sendJson($responseData);
		}

		foreach ($importGroup->getImports()->toArray() as $import) {
			if ($import->isActive)
				$resultResponse['imports'][$import->title] = $this->runImport($import);
		}

		if (!empty($resultResponse['imports']))
			$resultResponse['status'] = 'ok';

		foreach ($resultResponse['imports'] as $data) {
			if ($data['status'] == 'error') {
				$resultResponse['status'] = 'error';
				break;
			}
		}

		$this->sendJson($resultResponse);
	}

	protected function runImport(Import $import)
	{
		$importId     = $import->getId();
		$responseData = ['status' => 'error', 'message' => ''];
		if (!$import || !$import->type || !$import->processingType) {
			$responseData['message'] = "Import id '$id' not found";

			return $responseData;
		}

		$processingType = $this->processingTypes->getType($import->type, $import->processingType);
		if (!$processingType) {
			$responseData['message'] = "Import (id: '$id') processing type error";

			return $responseData;
		}

		try {
			if ($this->importsService->needUpdate($import->url)) {
				$responseData = $processingType->run($import, $this->importsService->getFileData($this->importsService->getFileContent($import), $import));
				$import       = $this->importsService->getEr()->find($import->getId());
				$this->importsService->updateLastRun($import);
			} else
				$this->importsService->saveInfoNoNewData($import);

			$responseData['status'] = 'ok';
		} catch (\Exception $e) {
			$responseData['message'] = $e->getMessage();
		}

		$this->importsService->clean();
		$this->em->getConnection()->prepare("INSERT INTO " . $this->em->getRepository(ImportHistory::class)->getClassMetadata()->getTableName() . " (import_id, status, created, `data`) VALUES (?, ?, ?, ?)")
			->execute([$importId, $responseData['status'], new DateTime(), serialize($responseData)]);


		return $responseData;
	}
}
