<?php declare(strict_types = 1);

namespace Import\AdminModule\Model\ImportType;

use Core\Model\UI\Form\BaseContainer;

/**
 * Interface ImportType
 * @package Import\AdminModule\Model\ImportType
 */
interface IImportType
{
	/**
	 * @param array $importKeys
	 * @param array $importValues
	 * @param       $defaults
	 *
	 * @return BaseContainer
	 */
	public function getFormSyncOpts(array $importKeys, array $importValues, $defaults);

	/**
	 * @param array $importKeys
	 * @param array $importValues
	 * @param       $defaults
	 *
	 * @return BaseContainer
	 */
	public function getFormContainer(array $importKeys, array $importValues, $defaults);

	/**
	 * @param array $values
	 *
	 * @return array
	 */
	public function processSubmitData($values);

	/**
	 * @param array $values
	 *
	 * @return array
	 */
	public function processSubmitSyncOpts($values);
}
