<?php declare(strict_types = 1);

namespace Import\AdminModule\Presenters;

use Nette\Application\ForbiddenRequestException;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	public function checkRequirements($element)
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access'))
			throw new ForbiddenRequestException();
	}
}
