<?php declare(strict_types = 1);

namespace Import\Model\Entities;

use Core\Model\Entities\TLang;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="import__dictionary")
 * @ORM\Entity
 */
class Dictionary
{
	use Identifier;
	use MagicAccessors;
	use TLang;

	/**
	 * @var string
	 * @ORM\Column(name="key", type="string", length=255, nullable=false)
	 */
	public $key;

	/**
	 * @var string
	 * @ORM\Column(name="value", type="string", length=255, nullable=false)
	 */
	public $value;

	public function __construct($key, $lang, $value)
	{
		$this->key = $key;
		$this->setLang($lang);
		$this->value = $value;
	}
}
