<?php declare(strict_types = 1);

namespace Import\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="import__import_history")
 * @ORM\Entity
 */
class ImportHistory
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var Import
	 * @ORM\ManyToOne(targetEntity="Import", inversedBy="history")
	 * @ORM\JoinColumn(name="import_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $import;

	/**
	 * @var string
	 * @ORM\Column(name="status", type="string", nullable=true)
	 */
	public $status;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	private $created;

	/**
	 * @var string
	 * @ORM\Column(name="data", type="array", nullable=true)
	 */
	public $data;

	public function __construct($import, $status)
	{
		$this->import = $import;
		$this->status = $status;
		$this->data   = [];
	}

	public function getCreated() { return $this->created; }
}
