<?php declare(strict_types = 1);

namespace Import\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Import\Model\Entities\Dictionary;

/**
 * Class DictionaryResolver
 * @package Import\AdminModule\Model
 *
 * @method Dictionary|object|null getReference($id)
 * @method Dictionary[]|null getAll()
 * @method Dictionary|null get($id)
 */
class DictionaryResolver extends BaseEntityService
{
	protected $entityClass = Dictionary::class;

	/** @var array */
	protected $cDictionary;

	/**
	 * @param string $value
	 * @param string $lang
	 *
	 * @return string
	 */
	public function findValue($value, $lang)
	{
		if (!is_string($value))
			return $value;

		return $this->load()[strtolower($value) . '_' . $lang] ?? $value;
	}

	/**
	 * @return array
	 */
	protected function load()
	{
		if (!$this->cDictionary) {
			foreach ($this->getEr()->createQueryBuilder('d')->getQuery()->getArrayResult() as $v)
				$this->cDictionary[strtolower($v['key']) . '_' . $v['lang']] = $v['value'];
		}

		return $this->cDictionary;
	}
}
