<?php declare(strict_types = 1);

namespace Import\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="import__import")
 * @ORM\Entity
 */
class Import
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="description", type="string", length=255, nullable=true)
	 */
	public $description;

	/**
	 * @var int
	 * @ORM\Column(name="is_active", type="smallint", nullable=false, options={"default": 1})
	 */
	public $isActive;

	/**
	 * @var string
	 * @ORM\Column(name="url", type="string", length=255, nullable=true)
	 */
	public $url;

	/**
	 * @var int
	 * @ORM\Column(name="allow_upload", type="smallint", nullable=false, options={"default": 0})
	 */
	public $allowUpload;

	/**
	 * @var string
	 * @ORM\Column(name="type", type="string", length=255, nullable=false)
	 */
	public $type;

	/**
	 * @var string
	 * @ORM\Column(name="processing_type", type="string", length=255, nullable=true)
	 */
	public $processingType;

	/**
	 * @var array
	 * @ORM\Column(name="data", type="array", nullable=true)
	 */
	public $data;

	/**
	 * @var DateTime
	 * @ORM\Column(name="last_run", type="datetime", nullable=true)
	 */
	public $lastRun;

	/**
	 * @var array
	 * @ORM\Column(name="sync_opts", type="array", nullable=true)
	 */
	public $syncOpts;

	/**
	 * @var ImportHistory[]
	 * @ORM\OneToMany(targetEntity="ImportHistory", mappedBy="import", orphanRemoval=true)
	 * @ORM\OrderBy({"created"="DESC"})
	 */
	private $history;

	/**
	 * @var ImportGroup
	 * @ORM\ManyToOne(targetEntity="ImportGroup", inversedBy="imports")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected $group;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	private $position;

	public function __construct($title, $type)
	{
		$this->title       = $title;
		$this->isActive    = 1;
		$this->allowUpload = 0;
		$this->type        = $type;
		$this->data        = [];
		$this->syncOpts    = [];
		$this->history     = new ArrayCollection();
		$this->setPosition(-1);
	}

	/*********************
	 * == SyncOpts
	 */

	public function getSyncOpts() { return $this->syncOpts; }

	public function getSyncOpt($key) { return $this->syncOpts[$key] ?? null; }

	public function setSyncOpt($key, $value = null)
	{
		if ($value == null) {
			unset($this->syncOpts[$key]);
		} else {
			$this->syncOpts[$key] = $value;
		}
	}

	/*****************
	 * == History
	 */

	public function getHistory() { return $this->history; }

	/******
	 * === Position
	 */

	public function setPosition($position)
	{
		$this->position = $position;
	}

	public function getPosition()
	{
		return $this->position;
	}

	/******
	 * === Group
	 */

	public function setGroup($group)
	{
		$this->group = $group;

		return $this;
	}
}
