<?php declare(strict_types = 1);

namespace Import\AdminModule\Model;

use Import\AdminModule\Model\ImportType\ImportType;

/**
 * Class ImportTypes
 * @package Import\AdminModule\Model
 */
class ImportTypes
{
	/** @var ImportType[] */
	protected $types = [];

	/**
	 * @param ImportType[] $types
	 */
	public function setTypes($types)
	{
		$this->types = [];
		foreach ($types as $type)
			$this->types[$type->name] = $type;
	}

	/**
	 * @return ImportType[]
	 */
	public function getTypes() { return $this->types; }

	/**
	 * @param string $type
	 *
	 * @return ImportType|null
	 */
	public function getType($type) { return $this->types[$type] ?? null; }

	/**
	 * @return array
	 */
	public function getSelectArr()
	{
		$return = [];

		foreach ($this->types as $type) {
			$return[$type->name] = $type->title;
		}

		return $return;
	}
}
