<?php declare(strict_types = 1);

namespace Import\AdminModule\Model;

use Import\AdminModule\Model\ProcessingType\IProcessingType;

/**
 * Class ProcessingTypes
 * @package Import\AdminModule\Model
 */
class ProcessingTypes
{
	/** @var IProcessingType[][] */
	protected $types = [];

	/**
	 * @param IProcessingType[] $types
	 */
	public function setTypes($types)
	{
		$this->types = [];
		foreach ($types as $k => $arr) {
			foreach ($arr as $type)
				$this->types[$k][$type->name] = $type;
		}
	}

	/**
	 * @return IProcessingType[][]
	 */
	public function getTypes() { return $this->types; }

	/**
	 * @param string $type
	 * @param string $processing
	 *
	 * @return IProcessingType[]|null
	 */
	public function getType($type, $processing) { return $this->types[$type][$processing] ?? null; }

	/**
	 * @param $type
	 *
	 * @return array
	 */
	public function getSelectArr($type)
	{
		$return = [];

		if (isset($this->types[$type]))
			foreach ($this->types[$type] as $type)
				$return[$type->name] = $type->title;
		if (isset($this->types['all']))
			foreach ($this->types['all'] as $type)
				$return[$type->name] = $type->title;

		return $return;
	}
}
