<?php declare(strict_types = 1);

namespace Import\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use Import\AdminModule\Components\IImportFormFactory;
use Import\AdminModule\Components\IImportGroupFormFactory;
use Import\AdminModule\Components\IImportGroupsGridFactory;
use Import\AdminModule\Components\IImportsGridFactory;
use Nette\Http\IResponse;

class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this->setHeader('import.title.import', 'fas fa-file-import');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title'    => 'import.menu.newImport',
				'link'     => 'Default:add',
				'ico'      => 'plus',
				'security' => ['Import:Admin' => 'create'],
			], [
				'title'    => 'import.menu.newImportGroup',
				'link'     => 'Default:addGroup',
				'ico'      => 'plus',
				'security' => ['Import:Admin' => 'create'],
			],
		]]);
	}

	public function actionAdd()
	{
		$this->setHeader('import.title.newImport', 'fa fa-plus');
	}

	public function actionEdit($id)
	{
		$this->setHeader('import.title.editImport', 'fa fa-edit');
	}

	public function actionAddGroup()
	{
		$this->setHeader('import.title.newImportGroup', 'fa fa-plus');
	}

	public function actionEditGroup($id)
	{
		$this->setHeader('import.title.editImportGroup', 'fa fa-edit');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentImportForm(IImportFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setImport($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('edit', $form->getCustomData('importId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentImportsGrid(IImportsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentImportGroupForm(IImportGroupFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setImportGroup($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editGroup', $form->getCustomData('importGroupId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentImportGroupsGrid(IImportGroupsGridFactory $factory)
	{
		return $factory->create();
	}
}
