<?php declare(strict_types = 1);

namespace Import\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * Class ImportGroup
 * @package Import\Model\Entities
 *
 * @ORM\Table(name="import__import_group")
 * @ORM\Entity
 */
class ImportGroup
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var int
	 * @ORM\Column(name="is_active", type="smallint", nullable=false, options={"default": 1})
	 */
	public $isActive;

	/**
	 * @var Import[]
	 * @ORM\OneToMany(targetEntity="Import", mappedBy="group")
	 * @ORM\OrderBy({"position"="ASC"})
	 */
	public $imports;

	/**
	 * ImportGroup constructor.
	 *
	 * @param $title
	 */
	public function __construct($title)
	{
		$this->title    = $title;
		$this->isActive = 1;
		$this->imports  = new ArrayCollection();
	}

	/**
	 * @param Import $import
	 *
	 * @return $this
	 */
	public function addImport($import)
	{
		if (!$this->imports->containsKey($import->getId())) {
			$this->imports->add($import);
			$import->setGroup($this);
		}

		return $this;
	}

	/**
	 * @param Import $import
	 *
	 * @return $this
	 */
	public function removeImport($import)
	{
		if ($this->imports->containsKey($import->getId())) {
			$this->imports->removeElement($import);
			$import->setGroup(null);
		}

		return $this;
	}

	/**
	 * @param Import[] $imports
	 *
	 * @return $this
	 */
	public function setImports($imports)
	{
		$this->imports = $imports;

		foreach ($imports as $import)
			$import->setGroup($this);

		return $this;
	}

	/**
	 * @return ArrayCollection|Import[]
	 */
	public function getImports() { return $this->imports; }
}
