document.addEventListener('click', e => {
	const target = e.target;

	if (target.matches('.change-price')) {
		const link = target.closest('.datagrid').previousElementSibling.dataset.changeLink;
		const wrap = target.closest('td');

		const inputRetailPrice = wrap.querySelector('[name="retailPrice"]');
		const inputPrice       = wrap.querySelector('[name="price"]');

		let data = {
			id: target.dataset.id
		};

		if (inputRetailPrice && inputRetailPrice.value)
			data.retailPrice = inputRetailPrice.value
		if (inputPrice && inputPrice.value)
			data.price = inputPrice.value

		global.naja.makeRequest('post', link, data, {
			history: false,
		});

		e.preventDefault();
	}
})
