<?php declare(strict_types = 1);

namespace Import\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Exception;
use Import\AdminModule\Model\ImportGroups;
use Import\AdminModule\Model\Imports;
use Import\Model\Entities\Import;
use Import\Model\Entities\ImportGroup;
use Nette\Application\BadRequestException;
use Nette\Utils\ArrayHash;

class ImportGroupForm extends BaseControl
{
	protected ?ImportGroup $importGroup = null;

	public function __construct(
		protected ImportGroups $importGroupsService,
		protected Imports      $importsService,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		$imports = $this->importsService->getEr()->findPairs([], 'title', ['position' => 'ASC'], 'id');

		$form->addText('title', 'import.import.title');
		$form->addBool('isActive', 'import.import.isActive');
		$form->addCheckboxList('imports', 'import.importGroupForm.imports', $imports);

		$form->addSaveCancelControl();

		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		try {
			$importGroup = $this->importGroup ?? new ImportGroup($values->title);

			$importGroup->title    = $values->title;
			$importGroup->isActive = $values->isActive;

			foreach ($importGroup->getImports()->toArray() as $import) {
				$import->setGroup(null);
				$this->em->persist($import);
			}

			foreach ($values->imports as $import) {
				/** @var Import $import */
				$import = $this->em->getReference(Import::class, $import);
				$import->setGroup($importGroup);
				$this->em->persist($import);
			}

			$flashMessage = $importGroup->getId() ? 'import.importGroupForm.edited' : 'import.importGroupForm.added';

			$this->em->persist($importGroup);
$this->em->flush();
			$form->addCustomData('importGroupId', $importGroup->getId());
			$this->presenter->flashMessageSuccess($flashMessage);
		} catch (Exception $e) {
			$form->addError($e->getMessage());
		}
	}

	/*******************************************************************************************************************
	 * ==================  GET / SET
	 */

	/**
	 * @param int|string $id
	 *
	 * @throws BadRequestException
	 */
	public function setImportGroup($id): void
	{
		$this->importGroup = $this->importGroupsService->get($id);

		if ($this->importGroup) {
			$form        = $this['form'];
			$importGroup = $this->importGroup;

			$form->setDefaults([
				'title'    => $importGroup->title,
				'isActive' => $importGroup->isActive,
			]);

			$d = [];
			foreach ($importGroup->getImports() as $import) {
				if (array_key_exists($import->getId(), $form->getComponent('imports')->getItems())) {
					$d[] = $import->getId();
				}
			}

			$form->getComponent('imports')->setDefaultValue($d);
		} else {
			$this->presenter->error();
		}
	}

}
