<?php declare(strict_types = 1);

namespace Import\AdminModule\Model;

use Import\AdminModule\Model\DataDownloader\DataDownloader;
use Import\AdminModule\Model\DataDownloader\IDataDownloader;

class DataDownloaders
{
	/** @var DataDownloader[] */
	protected array $downloaders = [];

	/**
	 * @param DataDownloader[] $downloaders
	 */
	public function setDownloaders(array $downloaders): void
	{
		$this->downloaders = [];
		foreach ($downloaders as $v) {
			$this->downloaders[$v->name] = $v;
		}
	}

	/**
	 * @return DataDownloader[]
	 */
	public function getDownloaders(): array { return $this->downloaders; }

	public function getDownloadersOptionsForSelect(): array
	{
		$result = [];

		foreach ($this->getDownloaders() as $downloader) {
			$result[$downloader->name] = $downloader->title;
		}

		return $result;
	}

	/**
	 * @return IDataDownloader|DataDownloader|null
	 */
	public function getDownloader(string $name) { return $this->downloaders[$name] ?? null; }
}
