<?php declare(strict_types = 1);

namespace Import\AdminModule\Model\Readers;

use Override;

class CsvReader implements IReader
{
	protected ?array $cachedRawData = null;

	public function __construct(
		protected ?string $fileContent,
	)
	{
	}

	#[Override]
	public function getKeys(): array
	{
		return $this->getRawData()['header'];
	}

	#[Override]
	public function getValues(): array
	{
		$result = [];
		foreach ($this->getRawData()['body'] as $row) {
			foreach ($row as $rk => $rv) {
				if (is_string($rv) || is_numeric($rv)) {
					$result[$rk][] = $rv;
				}
			}
		}

		foreach ($result as $k => $v) {
			$result[$k] = array_chunk(array_unique($v), 100)[0];
		}

		return $result;
	}

	protected function getRawData(): ?array
	{
		if ($this->cachedRawData === null) {
			$header = [];
			$body   = [];
			foreach (explode("\r\n", (string) $this->fileContent) as $rowK => $rowString) {
				$vals = explode(';', $rowString);

				if ($rowK === 0) {
					$header = $vals;
				} else {
					$body[] = $vals;
				}
			}

			$uniqueHeader = array_unique($header);
			if (count($uniqueHeader) <= 2 && (in_array('', $uniqueHeader) || in_array('0', $uniqueHeader))) {
				$tmp    = $header;
				$header = [];
				foreach (array_keys($tmp) as $k) {
					$header[$k] = $k;
				}
			}
			$this->cachedRawData = [
				'header' => $header,
				'body'   => $body,
			];
			$this->fileContent   = null;
		}

		return $this->cachedRawData;
	}

	public function getData(): array
	{
		return $this->getRawData()['body'];
	}

}
