<?php declare(strict_types = 1);

namespace Import\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190520081336 extends AbstractMigration
{
	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE import__dictionary (id INT AUTO_INCREMENT NOT NULL, `key` VARCHAR(255) NOT NULL, value VARCHAR(255) NOT NULL, lang VARCHAR(2) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE import__import (id INT AUTO_INCREMENT NOT NULL, group_id INT DEFAULT NULL, title VARCHAR(255) NOT NULL, description VARCHAR(255) DEFAULT NULL, is_active SMALLINT DEFAULT 1 NOT NULL, url VARCHAR(255) DEFAULT NULL, allow_upload SMALLINT DEFAULT 0 NOT NULL, type VARCHAR(255) NOT NULL, processing_type VARCHAR(255) DEFAULT NULL, data LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', last_run DATETIME DEFAULT NULL, sync_opts LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', position INT NOT NULL, INDEX IDX_776D8072FE54D947 (group_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE import__import_group (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, is_active SMALLINT DEFAULT 1 NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE import__import_history (id INT AUTO_INCREMENT NOT NULL, import_id INT DEFAULT NULL, status VARCHAR(255) DEFAULT NULL, created DATETIME NOT NULL, data LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', INDEX IDX_CA09CD72B6A263D9 (import_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('ALTER TABLE import__import ADD CONSTRAINT FK_776D8072FE54D947 FOREIGN KEY (group_id) REFERENCES import__import_group (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE import__import_history ADD CONSTRAINT FK_CA09CD72B6A263D9 FOREIGN KEY (import_id) REFERENCES import__import (id) ON DELETE CASCADE');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE import__import_history DROP FOREIGN KEY FK_CA09CD72B6A263D9');
		$this->addSql('ALTER TABLE import__import DROP FOREIGN KEY FK_776D8072FE54D947');
		$this->addSql('DROP TABLE import__dictionary');
		$this->addSql('DROP TABLE import__import');
		$this->addSql('DROP TABLE import__import_group');
		$this->addSql('DROP TABLE import__import_history');
	}
}
