<?php declare(strict_types = 1);

namespace Import\Model\Entities;

use DateTime;
use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'import__import_history')]
#[ORM\Entity]
class ImportHistory
{
	use TId;

	#[ORM\JoinColumn(name: 'import_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Import::class, cascade: ['persist'], inversedBy: 'history')]
	protected ?Import $import = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $status = null;

	#[ORM\Column(type: Types::DATETIME_MUTABLE)]
	protected DateTime $created;

	#[ORM\Column(type: Types::JSON, nullable: true)]
	public ?array $data = null;

	public function __construct(?Import $import, ?string $status)
	{
		$this->import  = $import;
		$this->status  = $status;
		$this->data    = [];
		$this->created = new DateTime();
	}

	public function getCreated(): DateTime { return $this->created; }
}
