<?php declare(strict_types = 1);

namespace Import\AdminModule\Model\ImportType;

use Core\Model\UI\Form\BaseContainer;

interface IImportType
{
	/**
	 * @param array $defaults
	 * @return BaseContainer
	 */
	public function getFormSyncOpts(array $importKeys, array $importValues, $defaults);

	/**
	 * @param array $defaults
	 * @return BaseContainer
	 */
	public function getFormContainer(array $importKeys, array $importValues, $defaults);

	/**
	 * @param array $values
	 * @return array
	 */
	public function processSubmitData($values);

	/**
	 * @param array $values
	 * @return array
	 */
	public function processSubmitSyncOpts($values);

}
