<?php declare(strict_types = 1);

namespace Import\AdminModule\Model;

use Import\AdminModule\Model\ImportType\ImportType;

class ImportTypes
{
	/** @var ImportType[] */
	protected array $types = [];

	/**
	 * @param ImportType[] $types
	 */
	public function setTypes(array $types): void
	{
		$this->types = [];
		foreach ($types as $type) {
			$this->types[$type->name] = $type;
		}
	}

	/**
	 * @return ImportType[]
	 */
	public function getTypes(): array { return $this->types; }

	public function getType(string $type): ?ImportType { return $this->types[$type] ?? null; }

	/**
	 * @return array<string, string>
	 */
	public function getSelectArr(): array
	{
		$return = [];

		foreach ($this->types as $type) {
			$return[$type->name] = $type->title;
		}

		return $return;
	}
}
