<?php declare(strict_types = 1);

namespace Import\AdminModule\Model;

use Import\AdminModule\Model\ProcessingType\ProcessingType;

class ProcessingTypes
{
	/** @var ProcessingType[][] */
	protected array $types = [];

	/**
	 * @param ProcessingType[][] $types
	 */
	public function setTypes(array $types): void
	{
		$this->types = [];
		foreach ($types as $k => $arr) {
			foreach ($arr as $type) {
				$this->types[$k][$type->name] = $type;
			}
		}
	}

	/**
	 * @return ProcessingType[][]
	 */
	public function getTypes(): array { return $this->types; }

	public function getType(string $type, string $processing): ?ProcessingType { return $this->types[$type][$processing] ?? null; }

	public function getSelectArr(string $type): array
	{
		$return = [];

		if (isset($this->types[$type])) {
			foreach ($this->types[$type] as $type) {
				$return[$type->name] = $type->title;
			}
		}
		if (isset($this->types['all'])) {
			foreach ($this->types['all'] as $type) {
				$return[$type->name] = $type->title;
			}
		}

		return $return;
	}

}
