<?php declare(strict_types = 1);

namespace Import\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use Import\AdminModule\Components\IImportFormFactory;
use Import\AdminModule\Components\IImportGroupFormFactory;
use Import\AdminModule\Components\IImportGroupsGridFactory;
use Import\AdminModule\Components\IImportsGridFactory;
use Import\AdminModule\Components\ImportForm;
use Import\AdminModule\Components\ImportGroupForm;
use Import\AdminModule\Components\ImportGroupsGrid;
use Import\AdminModule\Components\ImportsGrid;
use Nette\Http\IResponse;

class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this->setHeader('import.title.import', 'fas fa-file-import');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
			[
				'title'    => 'import.menu.newImport',
				'link'     => 'Default:add',
				'ico'      => 'plus',
				'security' => ['Import:Admin' => 'create'],
			], [
				'title'    => 'import.menu.newImportGroup',
				'link'     => 'Default:addGroup',
				'ico'      => 'plus',
				'security' => ['Import:Admin' => 'create'],
			],
		]]);
	}

	public function actionAdd(): void
	{
		$this->setHeader('import.title.newImport', 'fa fa-plus');
	}

	/**
	 * @param int|string $id
	 */
	public function actionEdit($id): void
	{
		$this->setHeader('import.title.editImport', 'fa fa-edit');
	}

	public function actionAddGroup(): void
	{
		$this->setHeader('import.title.newImportGroup', 'fa fa-plus');
	}

	/**
	 * @param int|string $id
	 */
	public function actionEditGroup($id): void
	{
		$this->setHeader('import.title.editImportGroup', 'fa fa-edit');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentImportForm(IImportFormFactory $factory): ImportForm
	{
		set_time_limit(120);
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setImport((int) $this->getParameter('id'));
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('edit', $form->getCustomData('importId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentImportsGrid(IImportsGridFactory $factory): ImportsGrid
	{
		return $factory->create();
	}

	protected function createComponentImportGroupForm(IImportGroupFormFactory $factory): ImportGroupForm
	{
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setImportGroup($this->getParameter('id'));
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editGroup', $form->getCustomData('importGroupId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentImportGroupsGrid(IImportGroupsGridFactory $factory): ImportGroupsGrid
	{
		return $factory->create();
	}
}
