<?php declare(strict_types = 1);

namespace Import\AdminModule\Presenters;

use Import\AdminModule\Components\IPriceCheckGridFactory;
use Import\AdminModule\Components\PriceCheckGrid;
use Import\AdminModule\Model\PriceCheck;

class PriceCheckPresenter extends BasePresenter
{
	protected PriceCheck $priceCheck;

	public function __construct(PriceCheck $priceCheck)
	{
		parent::__construct();
		$this->priceCheck = $priceCheck;
	}

	protected function startup()
	{
		parent::startup();
		$this->setHeader('import.title.priceCheck', 'fas fa-coins');
	}

	/*******************************************************************************************************************
	 * ============================== Handle
	 */

	public function handleLoadPrices(): void
	{
		$this->priceCheck->loadPrices();
		$this->flashMessageSuccess('import.priceCheck.dataDownloaded');
		$this->redrawControl('flashes');
		if ($this->getComponent('priceCheckGrid', false)) {
			$this['priceCheckGrid']->reload();
		}
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		{
			$this['navigation']->setData(['header' => [
				[
					'title' => 'import.menu.loadPricesFromImports',
					'link'  => ':loadPrices!',
					'ico'   => 'reload',
					'class' => 'ajax',
				],
			]]);
		}
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentPriceCheckGrid(IPriceCheckGridFactory $factory): PriceCheckGrid
	{
		return $factory->create();
	}
}
