<?php declare(strict_types = 1);

namespace Import\DI;

use Nette;
use Core\DI\CompilerExtension;
use Import\AdminModule\Model\DataDownloader\IDataDownloader;
use Import\AdminModule\Model\ImportType\IImportType;
use Import\AdminModule\Model\ProcessingType\IProcessingType;
use Nette\DI\Definitions\ServiceDefinition;

class ImportExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Import' => 'Import\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		/** @var ServiceDefinition $importsTypes */
		$importsTypes = $builder->getDefinition('import.admin.importTypes');
		$importsTypes->addSetup('setTypes', [$builder->findByType(IImportType::class)]);

		/** @var ServiceDefinition $dataDownloaders */
		$dataDownloaders = $builder->getDefinition('import.admin.dataDownloaders');
		$dataDownloaders->addSetup('setDownloaders', [$builder->findByType(IDataDownloader::class)]);

		$arr = [];
		foreach ($builder->findByType(IProcessingType::class) as $v) {
			$type = $v->getTag('type');

			if ($type) {
				$arr[$type][] = $v;
			}
		}

		if ($arr) {
			/** @var ServiceDefinition $processingTypes */
			$processingTypes = $builder->getDefinition('import.admin.processingTypes');
			$processingTypes->addSetup('setTypes', [$arr]);
		}
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init = $class->methods["initialize"];

		$init->addBody('Import\Model\ImportConfig::setParams($this->parameters[\'import\']);');
	}

}
