<?php declare(strict_types = 1);

namespace Import\Model\Entities;

use Core\Model\Entities\TLang;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="import__dictionary")
 * @ORM\Entity
 */
class Dictionary
{
	use TId;
	use TLang;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $key;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $value;

	public function __construct(string $key, ?string $lang, string $value)
	{
		$this->key = $key;
		$this->setLang($lang);
		$this->value = $value;
	}

}
