<?php declare(strict_types = 1);

namespace Import\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="import__import_group")
 * @ORM\Entity
 */
class ImportGroup
{
	use TId;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $title;

	/**
	 * @ORM\Column(type="smallint", nullable=false, options={"default": 1})
	 */
	public int $isActive;

	/**
	 * @var Collection<Import>
	 * @ORM\OneToMany(targetEntity="Import", mappedBy="group")
	 * @ORM\OrderBy({"position"="ASC"})
	 */
	public Collection $imports;

	public function __construct(string $title)
	{
		$this->title    = $title;
		$this->isActive = 1;
		$this->imports  = new ArrayCollection;
	}

	public function addImport(Import $import): self
	{
		if (!$this->imports->containsKey($import->getId())) {
			$this->imports->add($import);
			$import->setGroup($this);
		}

		return $this;
	}

	public function removeImport(Import $import): self
	{
		if ($this->imports->containsKey($import->getId())) {
			$this->imports->removeElement($import);
			$import->setGroup(null);
		}

		return $this;
	}

	/**
	 * @param Import[] $imports
	 */
	public function setImports(array $imports): self
	{
		$this->imports = new ArrayCollection($imports);

		foreach ($imports as $import) {
			$import->setGroup($this);
		}

		return $this;
	}

	/**
	 * @return Collection<Import>
	 */
	public function getImports(): Collection { return $this->imports; }

}
