<?php declare(strict_types = 1);

namespace Import\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="import__import_history")
 * @ORM\Entity
 */
class ImportHistory
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Import", inversedBy="history", cascade={"persist"})
	 * @ORM\JoinColumn(name="import_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected ?Import $import = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $status = null;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(type="datetime")
	 */
	private $created;

	/**
	 * @ORM\Column(type="array", nullable=true)
	 */
	public ?array $data = null;

	public function __construct(?Import $import, ?string $status)
	{
		$this->import = $import;
		$this->status = $status;
		$this->data   = [];
	}

	/**
	 * @return DateTime
	 */
	public function getCreated() { return $this->created; }
}
