<?php declare(strict_types = 1);

namespace Import\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Import\Model\Entities\Dictionary;

/**
 * @method Dictionary|null getReference($id)
 * @method Dictionary[] getAll()
 * @method Dictionary|null get($id)
 */
class DictionaryResolver extends BaseEntityService
{
	protected        $entityClass = Dictionary::class;
	protected ?array $cDictionary = null;

	/**
	 * @return string
	 */
	public function findValue(string|int $value, string $lang)
	{
		return $this->load()[strtolower((string) $value) . '_' . $lang] ?? $value;
	}

	protected function load(): array
	{
		if ($this->cDictionary === null) {
			$this->cDictionary = [];

			foreach ($this->getEr()->createQueryBuilder('d')->getQuery()->getArrayResult() as $v) {
				$this->cDictionary[strtolower((string) $v['key']) . '_' . $v['lang']] = (string) $v['value'];
			}
		}

		return $this->cDictionary;
	}
}
