<?php declare(strict_types = 1);

namespace Import\AdminModule\Model\Readers;

use Nette\Utils\Json;

class JsonReader implements IReader
{
	protected ?array $cachedRawData = null;

	public function __construct(protected ?string $fileContent)
	{
	}

	public function getKeys(): array
	{
		$keys = [];

		foreach ($this->getRawData()['header'] as $row) {
			if (!is_array($row)) {
				$keys[$row] = $row;
			} else {
				foreach (array_keys($row) as $k) {
					$keys[$k] = $k;
				}
			}
		}

		return $keys;
	}

	public function getValues(): array
	{
		$result = [];
		foreach ($this->getRawData()['body'] as $row) {
			foreach ($row as $rk => $rv) {
				if (is_string($rv) || is_numeric($rv)) {
					$result[$rk][] = $rv;
				}
			}
		}

		foreach ($result as $k => $v) {
			$result[$k] = array_chunk(array_unique($v), 100)[0];
		}

		return $result;
	}

	protected function getRawData(): ?array
	{
		if ($this->cachedRawData === null) {
			$header = [];
			$body   = [];
			foreach (Json::decode($this->fileContent, Json::FORCE_ARRAY) as $k => $v) {
				if (!is_array($v)) {
					continue;
				}
				$header   = [...$header, ...array_keys($v)];
				$body[$k] = $v;
			}

			$this->cachedRawData = [
				'header' => $header,
				'body'   => $body,
			];
			$this->fileContent   = null;
		}

		return $this->cachedRawData;
	}

	public function getData(): array
	{
		return $this->getRawData()['body'];
	}

}
