<?php declare(strict_types = 1);

namespace Import\Console;

use Doctrine;
use Doctrine\DBAL\Driver\Exception;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Import\AdminModule\Model\Imports;
use Import\AdminModule\Model\ProcessingTypes;
use Nette\DI\Attributes\Inject;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class RunGroup extends AbstractCommand
{
	#[Inject]
	public Imports $imports;

	#[Inject]
	public ProcessingTypes $processingTypes;

	/**
	 * @return void
	 */
	protected function configure()
	{
		$this->setName('imports:run-group')
			->addOption('id', null, InputOption::VALUE_REQUIRED)
			->setDescription('Run group import');
	}

	/**
	 * @return int
	 * @throws Exception
	 */
	protected function executeSchemaCommand(
		InputInterface                $input,
		OutputInterface               $output,
		Doctrine\ORM\Tools\SchemaTool $schemaTool,
		array                         $metadatas,
		SymfonyStyle                  $ui,
	)
	{
		$output->writeln('<fg=white;bg=#007bff>IMPORT - Run group</>');
		try {
			ini_set('memory_limit', '2G');
			$imports = $this->imports->getByGroup((int) $input->getOption('id'));

			foreach ($imports as $import) {
				if ($import && $import['isActive']) {

					$processingType = $this->processingTypes->getType($import['type'], $import['processingType']);
					if ($processingType) {
						$import       = $this->imports->getReference($import['id']);
						$fileContent  = $this->imports->getFileContent($import);
						$fileData     = $fileContent ? $this->imports->getFileData($fileContent, $import) : [];
						$responseData = $processingType->run($import, $fileData);
						$this->imports->updateLastRun($import->getId(), $import->url);
						$this->imports->addHistory($import->getId(), $responseData);

						$output->writeLn('<info>[OK] - Import done</info>');
					} else {
						$output->writeln('<error>[ERROR] - Processing type not found</error>');
					}
				} else {
					$output->writeln('<error>[ERROR] - Not found or is not active</error>');
				}
			}
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
