<?php declare(strict_types = 1);

namespace Import\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TLang;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'import__dictionary')]
#[ORM\Entity]
class Dictionary
{
	use TId;
	use TLang;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $key;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $value;

	public function __construct(string $key, ?string $lang, string $value)
	{
		$this->key = $key;
		$this->setLang($lang);
		$this->value = $value;
	}

}
