<?php declare(strict_types = 1);

namespace Import\Model\Entities;

use Core\Model\Entities\TId;
use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table(name: 'import__import_history')]
#[ORM\Entity]
class ImportHistory
{
	use TId;

	#[ORM\ManyToOne(targetEntity: Import::class, cascade: ['persist'], inversedBy: 'history')]
	#[ORM\JoinColumn(name: 'import_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	protected ?Import $import = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $status = null;

	#[Gedmo\Timestampable(on: 'create')]
	#[ORM\Column(type: Types::DATETIME_MUTABLE)]
	protected ?DateTimeInterface $created = null;

	#[ORM\Column(type: Types::JSON, nullable: true)]
	public ?array $data = null;

	public function __construct(?Import $import, ?string $status)
	{
		$this->import = $import;
		$this->status = $status;
		$this->data   = [];
	}

	public function getCreated(): ?DateTimeInterface { return $this->created; }
}
