<?php declare(strict_types = 1);

namespace Import\AdminModule\Components;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Import\AdminModule\Model\ImportGroups;
use Import\Model\Entities\ImportGroup;
use Nette\Application\ForbiddenRequestException;
use Nette\Utils\ArrayHash;
use Nette\Utils\Html;

/**
 * Class ImportGroupsGrid
 * @package Import\AdminModule\Components
 */
class ImportGroupsGrid extends BaseControl
{
	/** @var ImportGroup */
	protected $importGroupsService;

	public function __construct(ImportGroups $importGroup)
	{
		$this->importGroupsService = $importGroup;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * =================  Handle
	 */

	public function handleRun($id)
	{
		bdump($id);
	}

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();

		if (!$presenter->getUser()->isAllowed('Import:Admin', 'create'))
			throw new ForbiddenRequestException();

		if ($this->importGroupsService->remove($id))
			$presenter->flashMessageSuccess('default.deleted');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/*******************************************************************************************************************
	 * =================  Components
	 */

	public function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->importGroupsService->getEr()->createQueryBuilder('g');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('title', 'import.import.title', 'Default:editGroup');
		$grid->addColumnStatus('isActive', 'default.isActive')->setAlign('center')
			->addOption(1, 'default.publish')->setIcon('check')->setClass('btn-success')->setShowTitle(false)->endOption()
			->addOption(0, 'default.unPublish')->setIcon('times')->setClass('btn-danger')->setShowTitle(false)->endOption()
			->onChange[] = [$this, 'gridPublishChange'];

		// Actions
		$grid->addAction('run', '', ':Import:Cron:Default:runGroup')->setIcon('fas fa-play')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('fas fa-times')->setBsType('danger')
			->setRenderCondition(function($row) { return $this->getPresenter()->getUser()->isAllowed('Import:Admin', 'create'); });

		// Prototype
		$grid->getColumn('isActive')->getElementPrototype('td')->class[] = 'w1nw';

		return $grid;
	}

	/*******************************************************************************************************************
	 * =================  Grid function
	 */

	public function gridPublishChange($id, $newStatus)
	{
		$presenter = $this->getPresenter();

		if ($this->importsService->setActive($id, $newStatus))
			$presenter->flashMessageSuccess('default.publishChanged');
		else
			$presenter->flashMessageDanger('default.publishChangeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->redrawItem($id);
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
}
