<?php declare(strict_types = 1);

namespace Import\DI;

use Core\DI\CompilerExtension;
use Import\AdminModule\Model\ImportType\IImportType;
use Import\AdminModule\Model\ProcessingType\IProcessingType;
use Nette;

class ImportExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Import' => 'Import\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		$importsTypes = $builder->getDefinition('import.admin.importTypes');
		if ($importsTypes)
			$importsTypes->addSetup('setTypes', [$builder->findByType(IImportType::class)]);

		$arr = [];
		foreach ($builder->findByType(IProcessingType::class) as $v) {
			$type = $v->getTag('type');

			if ($type)
				$arr[$type][] = $v;
		}

		if ($arr) {
			$processingTypes = $builder->getDefinition('import.admin.processingTypes');
			$processingTypes->addSetup('setTypes', [$arr]);
		}
	}
}
