<?php declare(strict_types = 1);

namespace InfoPanels\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use InfoPanels\AdminModule\Components\IMessageFormFactory;
use InfoPanels\AdminModule\Components\IMessagesGridFactory;
use InfoPanels\AdminModule\Components\IPanelFormFactory;
use InfoPanels\AdminModule\Components\IPanelsGridFactory;
use InfoPanels\Model\Entities\Message;
use InfoPanels\Model\Entities\Panel;
use Nette\Http\IResponse;

class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this->setHeader('infoPanels.title.infoPanels', 'fas fa-info-circle');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'infoPanels.menu.addMessage',
				'link'  => 'Default:addMessage',
				'ico'   => 'plus',
			], [
				'title' => 'infoPanels.menu.addPanel',
				'link'  => 'Default:addPanel',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAddMessage()
	{
		$this->setHeader('infoPanels.title.addMessage', 'fas fa-info-circle');
	}

	public function actionEditMessage($id)
	{
		$message = $this->em->getRepository(Message::class)->find($id);

		if (!$message)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('infoPanels.title.editMessage'), $message->title);
		$this->setHeader('infoPanels.title.editMessage', 'fas fa-info-circle');
	}

	public function actionAddPanel()
	{
		$this->setHeader('infoPanels.title.addPanel', 'fas fa-info-circle');
	}

	public function actionEditPanel($id)
	{
		$panel = $this->em->getRepository(Panel::class)->find($id);

		if (!$panel)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('infoPanels.title.editPanel'), $panel->title);
		$this->setHeader('infoPanels.title.editPanel', 'fas fa-info-circle');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentPanelsGrid(IPanelsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentPanelForm(IPanelFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setPanel($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editPanel', $form->getCustomData('panelId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentMessagesGrid(IMessagesGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentMessageForm(IMessageFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setMessage($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editMessage', $form->getCustomData('messageId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}
}