<?php declare(strict_types = 1);

namespace InfoPanels\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Doctrine\ORM\Query;
use InfoPanels\Model\Entities\Panel;
use Doctrine\ORM\QueryBuilder;

/**
 * Class PanelsService
 * @package InfoPanel\FrontModule\Model
 */
class PanelsService extends BaseFrontEntityService
{
	protected $entityClass = Panel::class;

	/**
	 * @param QueryBuilder $qb
	 *
	 * @return QueryBuilder
	 */
	protected function setPublishedQueryBuilder(QueryBuilder $qb)
	{
		$qb->andWhere('p.isPublished = 1');

		if (in_array('m', $qb->getAllAliases()))
			$qb->andWhere('m.isPublished = 1');

		return $qb;
	}

	/**
	 * @param int|array $id
	 *
	 * @return array|mixed
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function get($id)
	{
		$qb = $this->getEr()->createQueryBuilder('p')->addSelect('m')
			->join('p.messages', 'm')
			->andWhere(is_array($id) ? 'p.id IN (:id)' : 'p.id = :id')->setParameter('id', $id);

		$qb = $this->setPublishedQueryBuilder($qb);
		$qb = $qb->getQuery();

		return is_array($id) ? $qb->getResult() : $qb->getOneOrNullResult();
	}

	/**
	 * @param string $orderBy
	 *
	 * @return array
	 */
	public function getAll($orderBy = 'p.title ASC')
	{
		$qb = $this->getEr()->createQueryBuilder('p')->leftJoin('p.messages', 'm');
		$qb = $this->setPublishedQueryBuilder($qb);

		$orderBy = explode(' ', $orderBy);
		$qb->orderBy($orderBy[0], $orderBy[1]);

		return $qb->getQuery()->getArrayResult();
	}
}
