<?php declare(strict_types = 1);

namespace InfoPanels\Model\Entities;

use Core\Model\TemplateReader\Entity\TTemplate;
use Core\Model\TemplateReader\Entity\ITemplate;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="infopanel__message")
 * @ORM\Entity
 */
class Message implements ITemplate
{
	use Identifier;
	use MagicAccessors;
	use TTemplate;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", nullable=false)
	 */
	public $isPublished;

	/**
	 * @var Panel
	 *
	 * @ORM\ManyToOne(targetEntity="Panel", inversedBy="messages")
	 * @ORM\JoinColumn(name="panel_id", referencedColumnName="id", nullable=false)
	 */
	public $panel;

	/**
	 * TemplatePage constructor.
	 *
	 * @param string $title
	 * @param Panel  $panel
	 * @param string $template
	 */
	public function __construct($title, $panel, $template)
	{
		$this->title       = $title;
		$this->template    = $template;
		$this->isPublished = 1;
		$this->panel       = $panel;
		$this->texts       = [];
	}
}