<?php declare(strict_types = 1);

namespace InfoPanels\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="infopanel__panel")
 * @ORM\Entity
 */
class Panel
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public $title;

	/**
	 * @var Message[]
	 *
	 * @ORM\OneToMany(targetEntity="Message", mappedBy="panel")
	 */
	public $messages;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1})
	 */
	public $isPublished;

	/**
	 * Panel constructor.
	 *
	 * @param string $title
	 */
	public function __construct($title)
	{
		$this->title       = $title;
		$this->isPublished = 1;
		$this->messages    = new ArrayCollection();
	}

	/******
	 * === Messages
	 */

	/**
	 * @return ArrayCollection|Message[]
	 */
	public function getMessages() { return $this->messages; }

	/**
	 * @param array|Message[] $messages
	 *
	 * @return $this
	 */
	public function setMessages(array $messages)
	{
		$this->messages = new ArrayCollection($messages);

		return $this;
	}

	/**
	 * @param $message
	 *
	 * @return bool
	 */
	public function addMessage($message)
	{
		if ($this->messages->contains($message)) {
			return true;
		}

		return $this->messages->add($message);
	}

	/**
	 * @param $message
	 *
	 * @return bool
	 */
	public function removeMessage($message)
	{
		if ($this->messages->contains($message)) {
			return $this->messages->removeElement($message);
		}

		return true;
	}
}