<?php declare(strict_types = 1);

namespace InfoPanels\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use InfoPanels\AdminModule\Model\PanelsService;
use InfoPanels\Model\Entities\Panel;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;

class PanelForm extends BaseControl
{
	/** @var Panel */
	public $panel;

	/** @var PanelsService */
	protected $panelsService;

	public function __construct(PanelsService $panelsService)
	{
		$this->panelsService = $panelsService;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addSaveCancelControl();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->panel) {
				$panel        = $this->panel;
				$flashMessage = 'infoPanels.panelForm.edited';
			} else {
				$panel        = new Panel($values->title);
				$flashMessage = 'infoPanels.panelForm.added';
			}

			$panel->title       = $values->title;
			$panel->isPublished = $values->isPublished;

			$this->em->persist($panel)->flush();
			$form->addCustomData('panelId', $panel->getId());
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	/*******************************************************************************************************************
	 * ==================  GET / SET
	 */

	public function setPanel($id)
	{
		$this->panel = $this->panelsService->get($id);

		if ($this->panel) {
			$this['form']->setDefaults([
				'title'       => $this->panel->title,
				'isPublished' => $this->panel->isPublished,
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}

}
