<?php declare(strict_types = 1);

namespace InfoPanels\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use InfoPanels\Model\Entities\Message;

/**
 * Class MessagesService
 * @package InfoPanel\AdminModule\Model
 *
 * @method Message|object|null getReference($id)
 * @method Message[]|null getAll()
 * @method Message|null get($id)
 */
class MessagesService extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Message::class;

	/**
	 * @return string
	 */
	public function getTemplatesDir() { return TEMPLATES_DIR . '/Front/default/InfoPanels/Templates'; }

	/**
	 * @param string $name
	 *
	 * @return string
	 */
	public function getTemplateFile($name) { return $this->getTemplatesDir() . '/' . $name; }
}