<?php declare(strict_types = 1);

namespace InfoPanels\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use InfoPanels\FrontModule\Model\PanelsService;

class InfoPanel extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'infoPanelsByPanel';

	/** @var PanelsService */
	protected $panelsService;

	public function __construct(PanelsService $panelsService)
	{
		$this->panelsService = $panelsService;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$panels = ['' => ''];
		foreach ($this->panelsService->getAll() as $p) {
			$panels[$p['id']] = $p['title'];
		}

		$formContainer->addCheckboxList($this->getName(), $this->getTitle(), $panels);
	}

	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		if (!$this->getDefault() && isset($params['default']))
			$this->setDefault((int) $params['default']);

		return $this->panelsService->get($this->getDefault());
	}
}