import Cookies from "js-cookie";
import {slideDown, slideUp} from 'es6-slide-up-down';

global.naja.addEventListener('complete', e => {
	showInfoPanel();
});

document.addEventListener('DOMContentLoaded', () => {
	showInfoPanel();
});

const showInfoPanel = () => {
	document.querySelectorAll('[data-infopanel-reveal]').forEach(el => {
		if (el.infoPanelInited === true) {
			return true;
		}

		el.infoPanelInited = true;
		let revealType     = el.dataset.infopanelReveal;
		let wait           = el.dataset.infopanelWait ? el.dataset.infopanelWait : 0;
		let style          = window.getComputedStyle(el);
		let key            = createKey(el);

		wait = 0;

		let canShow = !(style.display !== 'none' || Cookies.get(el.dataset.infopanelName) === key);

		setTimeout(() => {
			if (revealType == 'top') {
				if (canShow) {
					el.classList.add('panel-showed');
					slideDown(el);
				}

				el.querySelectorAll('.close').forEach(btn => {
					btn.addEventListener('click', (e) => {
						let revealType = el.dataset.infopanelReveal;

						slideUp(el, {
							duration: 400
						});

						if (el.dataset.removeAfterClose !== undefined) {
							setTimeout(function () {
								el.remove();
								el.classList.remove('panel-showed');
								closeEnd(el, btn);
							}, 400);
						} else {
							closeEnd(el, btn);
						}
					});
				})
			} else if (revealType == 'popup') {
				if (!canShow) {
					return;
				}
			}
		}, wait);

		function closeEnd(el, closeEl) {
			let options = {
				expires: parseInt(el.dataset.infopanelExpiration || 30),
			};

			Cookies.set(el.dataset.infopanelName, key, options);

			if (closeEl && closeEl.dataset.href !== undefined) {
				window.location.href = closeEl.dataset.href;
			}
		}
	});
};

const createKey = (el) => {
	let modified = el.dataset.infopanelModified;
	let id       = el.dataset.infopanelId;
	let tmp      = [];

	if (id)
		tmp.push(id);
	if (modified)
		tmp.push(modified);

	if (tmp.length) {
		tmp = tmp.join('_');
	} else {
		tmp = '1';
	}

	return tmp;
};
