<?php declare(strict_types = 1);

namespace InfoPanels\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Exception;
use InfoPanels\AdminModule\Model\PanelsService;
use InfoPanels\Model\Entities\Panel;
use InfoPanels\Model\InfoPanelsConfig;
use Nette\Application\BadRequestException;
use Nette\Utils\ArrayHash;

class PanelForm extends BaseControl
{
	public ?Panel $panel = null;

	public function __construct(
		protected PanelsService $panelsService,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);

		$positions = [];
		foreach ((array) InfoPanelsConfig::load('positions') as $group => $pos) {
			foreach ($pos as $v) {
				$positions[$v] = $this->t($group . '.infoPanelsPositions.' . $v);
			}
		}

		$form->addCheckboxList('positions', 'infoPanels.panel.positions', $positions);

		$form->addSaveCancelControl();

		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		try {
			if ($this->panel instanceof Panel) {
				$panel        = $this->panel;
				$flashMessage = 'infoPanels.panelForm.edited';
			} else {
				$panel        = new Panel($values->title);
				$flashMessage = 'infoPanels.panelForm.added';
			}

			$panel->title       = $values->title;
			$panel->isPublished = $values->isPublished;
			$panel->setPositions($values->positions);

			$this->em->persist($panel);
$this->em->flush();
			$form->addCustomData('panelId', $panel->getId());
			$this->presenter->flashMessageSuccess($flashMessage);
		} catch (Exception $e) {
			$form->addError($e->getMessage());
		}
	}

	/*******************************************************************************************************************
	 * ==================  GET / SET
	 */

	/**
	 * @param int|string $id
	 *
	 * @throws BadRequestException
	 */
	public function setPanel($id): void
	{
		$this->panel = $this->panelsService->get($id);

		if ($this->panel) {
			$this['form']->setDefaults([
				'title'       => $this->panel->title,
				'positions'   => $this->panel->getPositions(),
				'isPublished' => $this->panel->isPublished,
			]);
		} else {
			$this->presenter->error();
		}
	}

}
