<?php declare(strict_types = 1);

namespace InfoPanels\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use InfoPanels\Model\Entities\Panel;

/**
 * @method Panel|object|null getReference($id)
 * @method Panel[]|null getAll()
 * @method Panel|null get($id)
 */
class PanelsService extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Panel::class;

	protected ?array $cOptionsForSelect = null;

	public function getOptionsForSelect(): array
	{
		if ($this->cOptionsForSelect === null) {
			$this->cOptionsForSelect = [];
			foreach ($this->getEr()->createQueryBuilder('p')
				         ->select('p.id, p.title')
				         ->orderBy('p.id', 'DESC')
				         ->getQuery()->getScalarResult() as $row) {
				/** @var array $row */
				$this->cOptionsForSelect[$row['id']] = $row['title'];
			}
		}

		return $this->cOptionsForSelect;
	}
}
