<?php declare(strict_types = 1);

namespace InfoPanels\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use InfoPanels\Model\Listeners\PanelListener;

#[ORM\Table(name: 'infopanel__panel')]
#[ORM\Index(name: 'published', columns: ['id', 'is_published'])]
#[ORM\Entity]
#[ORM\EntityListeners([PanelListener::class])]
class Panel
{
	use TId;

	#[ORM\Column(type: Types::STRING, length: 255)]
	public string $title;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	protected ?string $positions = null;

	/** @var Collection<Message> */
	#[ORM\OneToMany(targetEntity: Message::class, mappedBy: 'panel')]
	public Collection $messages;

	#[ORM\Column(type: Types::SMALLINT, options: ['default' => 1])]
	public int $isPublished = 1;

	public function __construct(string $title)
	{
		$this->title       = $title;
		$this->isPublished = 1;
		$this->messages    = new ArrayCollection;
	}

	/******
	 * === Messages
	 */

	/**
	 * @return Collection<Message>
	 */
	public function getMessages(): Collection { return $this->messages; }

	/**
	 * @param Message[] $messages
	 */
	public function setMessages(array $messages): self
	{
		$this->messages = new ArrayCollection($messages);

		return $this;
	}

	public function addMessage(Message $message): void
	{
		if (!$this->messages->contains($message)) {
			$this->messages->add($message);
		}
	}

	public function removeMessage(Message $message): bool
	{
		if ($this->messages->contains($message)) {
			return $this->messages->removeElement($message);
		}

		return true;
	}

	public function setPositions(array $position): void { $this->positions = implode(',', $position); }

	public function getPositions(): array { return explode(',', (string) $this->positions); }
}
